/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.Label;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.commons.Method;
import jdk.internal.org.objectweb.asm.tree.AnnotationNode;
import jdk.internal.org.objectweb.asm.tree.ClassNode;
import jdk.internal.org.objectweb.asm.tree.MethodNode;
import jdk.jfr.Enabled;
import jdk.jfr.Event;
import jdk.jfr.Name;
import jdk.jfr.Registered;
import jdk.jfr.SettingControl;
import jdk.jfr.SettingDefinition;
import jdk.jfr.internal.ASMToolkit;
import jdk.jfr.internal.EventHandlerCreator;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.handlers.EventHandler;

public final class EventInstrumentation {
    public static final String FIELD_EVENT_THREAD = "eventThread";
    public static final String FIELD_STACK_TRACE = "stackTrace";
    public static final String FIELD_DURATION = "duration";
    static final String FIELD_EVENT_HANDLER = "eventHandler";
    static final String FIELD_START_TIME = "startTime";
    private static final jdk.internal.org.objectweb.asm.Type ANNOTATION_TYPE_NAME = jdk.internal.org.objectweb.asm.Type.getType(Name.class);
    private static final jdk.internal.org.objectweb.asm.Type ANNOTATION_TYPE_REGISTERED = jdk.internal.org.objectweb.asm.Type.getType(Registered.class);
    private static final jdk.internal.org.objectweb.asm.Type ANNOTATION_TYPE_ENABLED = jdk.internal.org.objectweb.asm.Type.getType(Enabled.class);
    private static final jdk.internal.org.objectweb.asm.Type TYPE_EVENT_HANDLER = jdk.internal.org.objectweb.asm.Type.getType(EventHandler.class);
    private static final jdk.internal.org.objectweb.asm.Type TYPE_SETTING_CONTROL = jdk.internal.org.objectweb.asm.Type.getType(SettingControl.class);
    private static final Method METHOD_COMMIT = new Method("commit", jdk.internal.org.objectweb.asm.Type.VOID_TYPE, new jdk.internal.org.objectweb.asm.Type[0]);
    private static final Method METHOD_BEGIN = new Method("begin", jdk.internal.org.objectweb.asm.Type.VOID_TYPE, new jdk.internal.org.objectweb.asm.Type[0]);
    private static final Method METHOD_END = new Method("end", jdk.internal.org.objectweb.asm.Type.VOID_TYPE, new jdk.internal.org.objectweb.asm.Type[0]);
    private static final Method METHOD_IS_ENABLED = new Method("isEnabled", jdk.internal.org.objectweb.asm.Type.BOOLEAN_TYPE, new jdk.internal.org.objectweb.asm.Type[0]);
    private static final Method METHOD_TIME_STAMP = new Method("timestamp", jdk.internal.org.objectweb.asm.Type.LONG_TYPE, new jdk.internal.org.objectweb.asm.Type[0]);
    private static final Method METHOD_EVENT_SHOULD_COMMIT = new Method("shouldCommit", jdk.internal.org.objectweb.asm.Type.BOOLEAN_TYPE, new jdk.internal.org.objectweb.asm.Type[0]);
    private static final Method METHOD_EVENT_HANDLER_SHOULD_COMMIT = new Method("shouldCommit", jdk.internal.org.objectweb.asm.Type.BOOLEAN_TYPE, new jdk.internal.org.objectweb.asm.Type[]{jdk.internal.org.objectweb.asm.Type.LONG_TYPE});
    private static final Method METHOD_DURATION = new Method("duration", jdk.internal.org.objectweb.asm.Type.LONG_TYPE, new jdk.internal.org.objectweb.asm.Type[]{jdk.internal.org.objectweb.asm.Type.LONG_TYPE});
    private final ClassNode classNode;
    private final List<SettingInfo> settingInfos;
    private final List<FieldInfo> fieldInfos;
    private final Method writeMethod;
    private final String eventHandlerXInternalName;
    private final String eventName;
    private boolean guardHandlerReference;
    private Class<?> superClass;

    EventInstrumentation(Class<?> clazz, byte[] byArray, long l) {
        this.superClass = clazz;
        this.classNode = this.createClassNode(byArray);
        this.settingInfos = EventInstrumentation.buildSettingInfos(clazz, this.classNode);
        this.fieldInfos = EventInstrumentation.buildFieldInfos(clazz, this.classNode);
        this.writeMethod = EventInstrumentation.makeWriteMethod(this.fieldInfos);
        this.eventHandlerXInternalName = ASMToolkit.getInternalName(EventHandlerCreator.makeEventHandlerName(l));
        String string = (String)EventInstrumentation.annotationValue(this.classNode, ANNOTATION_TYPE_NAME.getDescriptor(), String.class);
        this.eventName = string == null ? this.classNode.name.replace("/", ".") : string;
    }

    public String getClassName() {
        return this.classNode.name.replace("/", ".");
    }

    private ClassNode createClassNode(byte[] byArray) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(byArray);
        classReader.accept(classNode, 0);
        return classNode;
    }

    boolean isRegistered() {
        Registered registered;
        Boolean bl = (Boolean)EventInstrumentation.annotationValue(this.classNode, ANNOTATION_TYPE_REGISTERED.getDescriptor(), Boolean.class);
        if (bl != null) {
            return bl;
        }
        if (this.superClass != null && (registered = this.superClass.getAnnotation(Registered.class)) != null) {
            return registered.value();
        }
        return true;
    }

    boolean isEnabled() {
        Enabled enabled;
        Boolean bl = (Boolean)EventInstrumentation.annotationValue(this.classNode, ANNOTATION_TYPE_ENABLED.getDescriptor(), Boolean.class);
        if (bl != null) {
            return bl;
        }
        if (this.superClass != null && (enabled = this.superClass.getAnnotation(Enabled.class)) != null) {
            return enabled.value();
        }
        return true;
    }

    private static <T> T annotationValue(ClassNode classNode, String string, Class<?> clazz) {
        if (classNode.visibleAnnotations != null) {
            for (AnnotationNode annotationNode : classNode.visibleAnnotations) {
                String string2;
                List<Object> list;
                if (!string.equals(annotationNode.desc) || (list = annotationNode.values) == null || list.size() != 2) continue;
                Object object = list.get(0);
                Object object2 = list.get(1);
                if (!(object instanceof String) || object2 == null || clazz != object2.getClass() || !"value".equals(string2 = (String)object)) continue;
                return (T)object2;
            }
        }
        return null;
    }

    private static List<SettingInfo> buildSettingInfos(Class<?> clazz, ClassNode classNode) {
        SettingInfo settingInfo;
        int n;
        String string;
        jdk.internal.org.objectweb.asm.Type type;
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<SettingInfo> arrayList = new ArrayList<SettingInfo>();
        String string2 = jdk.internal.org.objectweb.asm.Type.getType(SettingDefinition.class).getDescriptor();
        Class clazz2 = classNode.methods.iterator();
        while (clazz2.hasNext()) {
            java.lang.reflect.Method[] methodArray = clazz2.next();
            if (methodArray.visibleAnnotations == null) continue;
            for (AnnotationNode annotationNode : methodArray.visibleAnnotations) {
                jdk.internal.org.objectweb.asm.Type object2;
                if (!string2.equals(annotationNode.desc) || !(object2 = jdk.internal.org.objectweb.asm.Type.getReturnType(methodArray.desc)).equals(jdk.internal.org.objectweb.asm.Type.getType(Boolean.TYPE)) || ((jdk.internal.org.objectweb.asm.Type[])(object = jdk.internal.org.objectweb.asm.Type.getArgumentTypes(methodArray.desc))).length != 1) continue;
                type = object[0];
                string = "setting" + arrayList.size();
                n = arrayList.size();
                settingInfo = new SettingInfo(string, n);
                settingInfo.methodName = methodArray.name;
                settingInfo.settingDescriptor = type.getDescriptor();
                settingInfo.internalSettingName = type.getInternalName();
                hashSet.add(methodArray.name);
                arrayList.add(settingInfo);
            }
        }
        for (clazz2 = clazz; clazz2 != Event.class; clazz2 = clazz2.getSuperclass()) {
            for (java.lang.reflect.Method method : clazz2.getDeclaredMethods()) {
                if (hashSet.contains(method.getName()) || Modifier.isPrivate(method.getModifiers()) || !method.getReturnType().equals(Boolean.TYPE) || method.getParameterCount() != 1) continue;
                object = method.getParameters()[0];
                type = jdk.internal.org.objectweb.asm.Type.getType(((Parameter)object).getType());
                string = "setting" + arrayList.size();
                n = arrayList.size();
                settingInfo = new SettingInfo(string, n);
                settingInfo.methodName = method.getName();
                settingInfo.settingDescriptor = type.getDescriptor();
                settingInfo.internalSettingName = type.getInternalName();
                hashSet.add(method.getName());
                arrayList.add(settingInfo);
            }
        }
        return arrayList;
    }

    private static List<FieldInfo> buildFieldInfos(Class<?> clazz, ClassNode classNode) {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<FieldInfo> arrayList = new ArrayList<FieldInfo>(classNode.fields.size());
        arrayList.add(new FieldInfo(FIELD_START_TIME, jdk.internal.org.objectweb.asm.Type.LONG_TYPE.getDescriptor(), classNode.name));
        arrayList.add(new FieldInfo(FIELD_DURATION, jdk.internal.org.objectweb.asm.Type.LONG_TYPE.getDescriptor(), classNode.name));
        Class clazz2 = classNode.fields.iterator();
        while (clazz2.hasNext()) {
            Field[] fieldArray = clazz2.next();
            String string = jdk.internal.org.objectweb.asm.Type.getType(fieldArray.desc).getClassName();
            if (hashSet.contains(fieldArray.name) || !EventInstrumentation.isValidField(fieldArray.access, string)) continue;
            FieldInfo fieldInfo = new FieldInfo(fieldArray.name, fieldArray.desc, classNode.name);
            arrayList.add(fieldInfo);
            hashSet.add(fieldArray.name);
        }
        for (clazz2 = clazz; clazz2 != Event.class; clazz2 = clazz2.getSuperclass()) {
            for (Field field : clazz2.getDeclaredFields()) {
                String string;
                if (Modifier.isPrivate(field.getModifiers()) || !EventInstrumentation.isValidField(field.getModifiers(), field.getType().getName()) || hashSet.contains(string = field.getName())) continue;
                jdk.internal.org.objectweb.asm.Type type = jdk.internal.org.objectweb.asm.Type.getType(field.getType());
                String string2 = ASMToolkit.getInternalName(clazz2.getName());
                arrayList.add(new FieldInfo(string, type.getDescriptor(), string2));
                hashSet.add(string);
            }
        }
        return arrayList;
    }

    public static boolean isValidField(int n, String string) {
        if (Modifier.isTransient(n) || Modifier.isStatic(n)) {
            return false;
        }
        return Type.isValidJavaFieldType(string);
    }

    public byte[] buildInstrumented() {
        this.makeInstrumented();
        return this.toByteArray();
    }

    private byte[] toByteArray() {
        ClassWriter classWriter = new ClassWriter(2);
        this.classNode.accept(classWriter);
        classWriter.visitEnd();
        byte[] byArray = classWriter.toByteArray();
        Utils.writeGeneratedASM(this.classNode.name, byArray);
        return byArray;
    }

    public byte[] builUninstrumented() {
        this.makeUninstrumented();
        return this.toByteArray();
    }

    private void makeInstrumented() {
        this.updateMethod(METHOD_IS_ENABLED, methodVisitor -> {
            Label label = new Label();
            if (this.guardHandlerReference) {
                methodVisitor.visitFieldInsn(178, this.getInternalClassName(), FIELD_EVENT_HANDLER, TYPE_EVENT_HANDLER.getDescriptor());
                methodVisitor.visitJumpInsn(198, label);
            }
            methodVisitor.visitFieldInsn(178, this.getInternalClassName(), FIELD_EVENT_HANDLER, TYPE_EVENT_HANDLER.getDescriptor());
            ASMToolkit.invokeVirtual(methodVisitor, TYPE_EVENT_HANDLER.getInternalName(), METHOD_IS_ENABLED);
            methodVisitor.visitInsn(172);
            if (this.guardHandlerReference) {
                methodVisitor.visitLabel(label);
                methodVisitor.visitFrame(3, 0, null, 0, null);
                methodVisitor.visitInsn(3);
                methodVisitor.visitInsn(172);
            }
        });
        this.updateMethod(METHOD_BEGIN, methodVisitor -> {
            methodVisitor.visitIntInsn(25, 0);
            ASMToolkit.invokeStatic(methodVisitor, TYPE_EVENT_HANDLER.getInternalName(), METHOD_TIME_STAMP);
            methodVisitor.visitFieldInsn(181, this.getInternalClassName(), FIELD_START_TIME, "J");
            methodVisitor.visitInsn(177);
        });
        this.updateMethod(METHOD_END, methodVisitor -> {
            methodVisitor.visitIntInsn(25, 0);
            methodVisitor.visitIntInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.getInternalClassName(), FIELD_START_TIME, "J");
            ASMToolkit.invokeStatic(methodVisitor, TYPE_EVENT_HANDLER.getInternalName(), METHOD_DURATION);
            methodVisitor.visitFieldInsn(181, this.getInternalClassName(), FIELD_DURATION, "J");
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
        });
        this.updateMethod(METHOD_COMMIT, methodVisitor -> {
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, this.getInternalClassName(), METHOD_IS_ENABLED.getName(), METHOD_IS_ENABLED.getDescriptor(), false);
            Label label = new Label();
            methodVisitor.visitJumpInsn(154, label);
            methodVisitor.visitInsn(177);
            methodVisitor.visitLabel(label);
            methodVisitor.visitFrame(3, 0, null, 0, null);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.getInternalClassName(), FIELD_START_TIME, "J");
            methodVisitor.visitInsn(9);
            methodVisitor.visitInsn(148);
            Label label2 = new Label();
            methodVisitor.visitJumpInsn(154, label2);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(184, TYPE_EVENT_HANDLER.getInternalName(), METHOD_TIME_STAMP.getName(), METHOD_TIME_STAMP.getDescriptor(), false);
            methodVisitor.visitFieldInsn(181, this.getInternalClassName(), FIELD_START_TIME, "J");
            Label label3 = new Label();
            methodVisitor.visitJumpInsn(167, label3);
            methodVisitor.visitLabel(label2);
            methodVisitor.visitFrame(3, 0, null, 0, null);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.getInternalClassName(), FIELD_DURATION, "J");
            methodVisitor.visitInsn(9);
            methodVisitor.visitInsn(148);
            methodVisitor.visitJumpInsn(154, label3);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(184, TYPE_EVENT_HANDLER.getInternalName(), METHOD_TIME_STAMP.getName(), METHOD_TIME_STAMP.getDescriptor(), false);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.getInternalClassName(), FIELD_START_TIME, "J");
            methodVisitor.visitInsn(101);
            methodVisitor.visitFieldInsn(181, this.getInternalClassName(), FIELD_DURATION, "J");
            methodVisitor.visitLabel(label3);
            methodVisitor.visitFrame(3, 0, null, 0, null);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, this.getInternalClassName(), METHOD_EVENT_SHOULD_COMMIT.getName(), METHOD_EVENT_SHOULD_COMMIT.getDescriptor(), false);
            Label label4 = new Label();
            methodVisitor.visitJumpInsn(153, label4);
            methodVisitor.visitFieldInsn(178, this.getInternalClassName(), FIELD_EVENT_HANDLER, jdk.internal.org.objectweb.asm.Type.getDescriptor(EventHandler.class));
            methodVisitor.visitTypeInsn(192, this.eventHandlerXInternalName);
            for (FieldInfo fieldInfo : this.fieldInfos) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, fieldInfo.internalClassName, fieldInfo.fieldName, fieldInfo.fieldDescriptor);
            }
            methodVisitor.visitMethodInsn(182, this.eventHandlerXInternalName, this.writeMethod.getName(), this.writeMethod.getDescriptor(), false);
            methodVisitor.visitLabel(label4);
            methodVisitor.visitFrame(3, 0, null, 0, null);
            methodVisitor.visitInsn(177);
            methodVisitor.visitEnd();
        });
        this.updateMethod(METHOD_EVENT_SHOULD_COMMIT, methodVisitor -> {
            Label label = new Label();
            methodVisitor.visitFieldInsn(178, this.getInternalClassName(), FIELD_EVENT_HANDLER, jdk.internal.org.objectweb.asm.Type.getDescriptor(EventHandler.class));
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.getInternalClassName(), FIELD_DURATION, "J");
            ASMToolkit.invokeVirtual(methodVisitor, TYPE_EVENT_HANDLER.getInternalName(), METHOD_EVENT_HANDLER_SHOULD_COMMIT);
            methodVisitor.visitJumpInsn(153, label);
            for (SettingInfo settingInfo : this.settingInfos) {
                methodVisitor.visitIntInsn(25, 0);
                methodVisitor.visitFieldInsn(178, this.getInternalClassName(), FIELD_EVENT_HANDLER, jdk.internal.org.objectweb.asm.Type.getDescriptor(EventHandler.class));
                methodVisitor.visitTypeInsn(192, this.eventHandlerXInternalName);
                methodVisitor.visitFieldInsn(180, this.eventHandlerXInternalName, settingInfo.fieldName, TYPE_SETTING_CONTROL.getDescriptor());
                methodVisitor.visitTypeInsn(192, settingInfo.internalSettingName);
                methodVisitor.visitMethodInsn(182, this.getInternalClassName(), settingInfo.methodName, "(" + settingInfo.settingDescriptor + ")Z", false);
                methodVisitor.visitJumpInsn(153, label);
            }
            methodVisitor.visitInsn(4);
            methodVisitor.visitInsn(172);
            methodVisitor.visitLabel(label);
            methodVisitor.visitInsn(3);
            methodVisitor.visitInsn(172);
        });
    }

    private void makeUninstrumented() {
        this.updateExistingWithReturnFalse(METHOD_EVENT_SHOULD_COMMIT);
        this.updateExistingWithReturnFalse(METHOD_IS_ENABLED);
        this.updateExistingWithEmptyVoidMethod(METHOD_COMMIT);
        this.updateExistingWithEmptyVoidMethod(METHOD_BEGIN);
        this.updateExistingWithEmptyVoidMethod(METHOD_END);
    }

    private final void updateExistingWithEmptyVoidMethod(Method method) {
        this.updateMethod(method, methodVisitor -> methodVisitor.visitInsn(177));
    }

    private final void updateExistingWithReturnFalse(Method method) {
        this.updateMethod(method, methodVisitor -> {
            methodVisitor.visitInsn(3);
            methodVisitor.visitInsn(172);
        });
    }

    private MethodNode getMethodNode(Method method) {
        for (MethodNode methodNode : this.classNode.methods) {
            if (!methodNode.name.equals(method.getName()) || !methodNode.desc.equals(method.getDescriptor())) continue;
            return methodNode;
        }
        return null;
    }

    private final void updateMethod(Method method, Consumer<MethodVisitor> consumer) {
        MethodNode methodNode = this.getMethodNode(method);
        int n = this.classNode.methods.indexOf(methodNode);
        this.classNode.methods.remove(methodNode);
        MethodVisitor methodVisitor = this.classNode.visitMethod(methodNode.access, methodNode.name, methodNode.desc, null, null);
        methodVisitor.visitCode();
        consumer.accept(methodVisitor);
        methodVisitor.visitMaxs(0, 0);
        MethodNode methodNode2 = this.getMethodNode(method);
        this.classNode.methods.remove(methodNode2);
        this.classNode.methods.add(n, methodNode2);
    }

    public static Method makeWriteMethod(List<FieldInfo> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (FieldInfo fieldInfo : list) {
            stringBuilder.append(fieldInfo.fieldDescriptor);
        }
        stringBuilder.append(")V");
        return new Method("write", stringBuilder.toString());
    }

    private String getInternalClassName() {
        return this.classNode.name;
    }

    public List<SettingInfo> getSettingInfos() {
        return this.settingInfos;
    }

    public List<FieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setGuardHandler(boolean bl) {
        this.guardHandlerReference = bl;
    }

    static final class FieldInfo {
        private static final jdk.internal.org.objectweb.asm.Type STRING = jdk.internal.org.objectweb.asm.Type.getType(String.class);
        final String fieldName;
        final String fieldDescriptor;
        final String internalClassName;

        public FieldInfo(String string, String string2, String string3) {
            this.fieldName = string;
            this.fieldDescriptor = string2;
            this.internalClassName = string3;
        }

        public boolean isString() {
            return STRING.getDescriptor().equals(this.fieldDescriptor);
        }
    }

    static final class SettingInfo {
        private String methodName;
        private String internalSettingName;
        private String settingDescriptor;
        final String fieldName;
        final int index;
        SettingControl settingControl;

        public SettingInfo(String string, int n) {
            this.fieldName = string;
            this.index = n;
        }
    }
}

