/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.dcmd;

import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.Options;
import jdk.jfr.internal.Repository;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.dcmd.AbstractDCmd;
import jdk.jfr.internal.dcmd.DCmdException;

final class DCmdConfigure
extends AbstractDCmd {
    DCmdConfigure() {
    }

    public String execute(String string, String string2, Integer n, Long l, Long l2, Long l3, Long l4, Long l5, Boolean bl) throws DCmdException {
        if (LogTag.JFR_DCMD.shouldLog(LogLevel.DEBUG)) {
            Logger.log(LogTag.JFR_DCMD, LogLevel.DEBUG, "Executing DCmdConfigure: repositorypath=" + string + ", dumppath=" + string2 + ", stackdepth=" + n + ", globalbuffercount=" + l + ", globalbuffersize=" + l2 + ", thread_buffer_size" + l3 + ", memorysize" + l4 + ", maxchunksize=" + l5 + ", samplethreads" + bl);
        }
        boolean bl2 = false;
        if (string != null) {
            try {
                SecuritySupport.SafePath safePath = new SecuritySupport.SafePath(string);
                Repository.getRepository().setBasePath(safePath);
                Logger.log(LogTag.JFR, LogLevel.INFO, "Base repository path set to " + string);
            }
            catch (Exception exception) {
                throw new DCmdException("Could not use " + string + " as repository. " + exception.getMessage(), new Object[]{exception});
            }
            this.printRepositoryPath();
            bl2 = true;
        }
        if (string2 != null) {
            Options.setDumpPath(new SecuritySupport.SafePath(string2));
            Logger.log(LogTag.JFR, LogLevel.INFO, "Emergency dump path set to " + string2);
            this.printDumpPath();
            bl2 = true;
        }
        if (n != null) {
            Options.setStackDepth(n);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Stack depth set to " + n);
            this.printStackDepth();
            bl2 = true;
        }
        if (l != null) {
            Options.setGlobalBufferCount(l);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Global buffer count set to " + l);
            this.printGlobalBufferCount();
            bl2 = true;
        }
        if (l2 != null) {
            Options.setGlobalBufferSize(l2);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Global buffer size set to " + l2);
            this.printGlobalBufferSize();
            bl2 = true;
        }
        if (l3 != null) {
            Options.setThreadBufferSize(l3);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Thread buffer size set to " + l3);
            this.printThreadBufferSize();
            bl2 = true;
        }
        if (l4 != null) {
            Options.setMemorySize(l4);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Memory size set to " + l4);
            this.printMemorySize();
            bl2 = true;
        }
        if (l5 != null) {
            Options.setMaxChunkSize(l5);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Max chunk size set to " + l5);
            this.printMaxChunkSize();
            bl2 = true;
        }
        if (bl != null) {
            Options.setSampleThreads(bl);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Sample threads set to " + bl);
            this.printSampleThreads();
            bl2 = true;
        }
        if (!bl2) {
            this.println("Current configuration:", new Object[0]);
            this.println();
            this.printRepositoryPath();
            this.printStackDepth();
            this.printGlobalBufferCount();
            this.printGlobalBufferSize();
            this.printThreadBufferSize();
            this.printMemorySize();
            this.printMaxChunkSize();
            this.printSampleThreads();
        }
        return this.getResult();
    }

    private void printRepositoryPath() {
        this.print("Repository path: ");
        this.printPath(Repository.getRepository().getRepositoryPath());
        this.println();
    }

    private void printDumpPath() {
        this.print("Dump path: ");
        this.printPath(Options.getDumpPath());
        this.println();
    }

    private void printSampleThreads() {
        this.println("Sample threads: " + Options.getSampleThreads(), new Object[0]);
    }

    private void printStackDepth() {
        this.println("Stack depth: " + Options.getStackDepth(), new Object[0]);
    }

    private void printGlobalBufferCount() {
        this.println("Global buffer count: " + Options.getGlobalBufferCount(), new Object[0]);
    }

    private void printGlobalBufferSize() {
        this.print("Global buffer size: ");
        this.printBytes(Options.getGlobalBufferSize());
        this.println();
    }

    private void printThreadBufferSize() {
        this.print("Thread buffer size: ");
        this.printBytes(Options.getThreadBufferSize());
        this.println();
    }

    private void printMemorySize() {
        this.print("Memory size: ");
        this.printBytes(Options.getMemorySize());
        this.println();
    }

    private void printMaxChunkSize() {
        this.print("Max chunk size: ");
        this.printBytes(Options.getMaxChunkSize());
        this.println();
    }
}

