/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import sun.nio.fs.UnixConstants;

class UnixFileModeAttribute {
    static final int ALL_PERMISSIONS = UnixConstants.S_IRUSR | UnixConstants.S_IWUSR | UnixConstants.S_IXUSR | UnixConstants.S_IRGRP | UnixConstants.S_IWGRP | UnixConstants.S_IXGRP | UnixConstants.S_IROTH | UnixConstants.S_IWOTH | UnixConstants.S_IXOTH;
    static final int ALL_READWRITE = UnixConstants.S_IRUSR | UnixConstants.S_IWUSR | UnixConstants.S_IRGRP | UnixConstants.S_IWGRP | UnixConstants.S_IROTH | UnixConstants.S_IWOTH;
    static final int TEMPFILE_PERMISSIONS = UnixConstants.S_IRUSR | UnixConstants.S_IWUSR | UnixConstants.S_IXUSR;

    private UnixFileModeAttribute() {
    }

    static int toUnixMode(Set<PosixFilePermission> set) {
        int n = 0;
        for (PosixFilePermission posixFilePermission : set) {
            if (posixFilePermission == null) {
                throw new NullPointerException();
            }
            switch (posixFilePermission) {
                case OWNER_READ: {
                    n |= UnixConstants.S_IRUSR;
                    break;
                }
                case OWNER_WRITE: {
                    n |= UnixConstants.S_IWUSR;
                    break;
                }
                case OWNER_EXECUTE: {
                    n |= UnixConstants.S_IXUSR;
                    break;
                }
                case GROUP_READ: {
                    n |= UnixConstants.S_IRGRP;
                    break;
                }
                case GROUP_WRITE: {
                    n |= UnixConstants.S_IWGRP;
                    break;
                }
                case GROUP_EXECUTE: {
                    n |= UnixConstants.S_IXGRP;
                    break;
                }
                case OTHERS_READ: {
                    n |= UnixConstants.S_IROTH;
                    break;
                }
                case OTHERS_WRITE: {
                    n |= UnixConstants.S_IWOTH;
                    break;
                }
                case OTHERS_EXECUTE: {
                    n |= UnixConstants.S_IXOTH;
                }
            }
        }
        return n;
    }

    static int toUnixMode(int n, FileAttribute<?> ... fileAttributeArray) {
        int n2 = n;
        for (FileAttribute<?> fileAttribute : fileAttributeArray) {
            String string = fileAttribute.name();
            if (!string.equals("posix:permissions") && !string.equals("unix:permissions")) {
                throw new UnsupportedOperationException("'" + fileAttribute.name() + "' not supported as initial attribute");
            }
            n2 = UnixFileModeAttribute.toUnixMode((Set)fileAttribute.value());
        }
        return n2;
    }
}

