/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.util.List;
import jdk.jfr.Event;
import jdk.jfr.internal.EventWriter;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Options;

public final class JVM {
    private static final JVM jvm = new JVM();
    static final Object FILE_DELTA_CHANGE = new Object();
    static final long RESERVED_CLASS_ID_LIMIT = 400L;
    private volatile boolean recording;
    private volatile boolean nativeOK;

    private static native void registerNatives();

    public static JVM getJVM() {
        return jvm;
    }

    private JVM() {
    }

    public native void beginRecording();

    public static native long counterTime();

    public native boolean emitEvent(long var1, long var3, long var5);

    public native void endRecording();

    public native List<Class<? extends Event>> getAllEventClasses();

    public native long getUnloadedEventClassCount();

    public static native long getClassId(Class<?> var0);

    public static native long getClassIdNonIntrinsic(Class<?> var0);

    public native String getPid();

    public native long getStackTraceId(int var1);

    public native long getThreadId(Thread var1);

    public native long getTicksFrequency();

    public static native void log(int var0, int var1, String var2);

    public static native void subscribeLogLevel(LogTag var0, int var1);

    public synchronized native void retransformClasses(Class<?>[] var1);

    public native void setEnabled(long var1, boolean var3);

    public native void setFileNotification(long var1);

    public native void setGlobalBufferCount(long var1) throws IllegalArgumentException, IllegalStateException;

    public native void setGlobalBufferSize(long var1) throws IllegalArgumentException;

    public native void setMemorySize(long var1) throws IllegalArgumentException;

    public native void setMethodSamplingInterval(long var1, long var3);

    public native void setOutput(String var1);

    public native void setForceInstrumentation(boolean var1);

    public native void setSampleThreads(boolean var1) throws IllegalStateException;

    public native void setCompressedIntegers(boolean var1) throws IllegalStateException;

    public native void setStackDepth(int var1) throws IllegalArgumentException, IllegalStateException;

    public native void setStackTraceEnabled(long var1, boolean var3);

    public native void setThreadBufferSize(long var1) throws IllegalArgumentException, IllegalStateException;

    public native boolean setThreshold(long var1, long var3);

    public native void storeMetadataDescriptor(byte[] var1);

    public void endRecording_() {
        this.endRecording();
        this.recording = false;
    }

    public void beginRecording_() {
        this.beginRecording();
        this.recording = true;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public native boolean getAllowedToDoEventRetransforms();

    private native boolean createJFR(boolean var1) throws IllegalStateException;

    private native boolean destroyJFR();

    public boolean createFailedNativeJFR() throws IllegalStateException {
        return this.createJFR(true);
    }

    public void createNativeJFR() {
        this.nativeOK = this.createJFR(false);
    }

    public boolean destroyNativeJFR() {
        boolean bl = this.destroyJFR();
        this.nativeOK = !bl;
        return bl;
    }

    public boolean hasNativeJFR() {
        return this.nativeOK;
    }

    public native boolean isAvailable();

    public native double getTimeConversionFactor();

    public native long getTypeId(Class<?> var1);

    public static native Object getEventWriter();

    public static native EventWriter newEventWriter();

    public static native boolean flush(EventWriter var0, int var1, int var2);

    public native void setRepositoryLocation(String var1);

    public native void abort(String var1);

    public static native boolean addStringConstant(boolean var0, long var1, String var3);

    public native long getEpochAddress();

    public native void uncaughtException(Thread var1, Throwable var2);

    public native boolean setCutoff(long var1, long var3);

    public native void emitOldObjectSamples(long var1, boolean var3);

    public native boolean shouldRotateDisk();

    static {
        JVM.registerNatives();
        Options.ensureInitialized();
    }
}

