/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.dcmd;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jdk.jfr.FlightRecorder;
import jdk.jfr.Recording;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.OldObjectSample;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.dcmd.AbstractDCmd;
import jdk.jfr.internal.dcmd.DCmdException;
import jdk.jfr.internal.jfc.JFC;

final class DCmdStart
extends AbstractDCmd {
    DCmdStart() {
    }

    public String execute(String string, String[] stringArray, Long l, Long l2, Boolean bl, String string2, Long l3, Long l4, Boolean bl2, Boolean bl3) throws DCmdException {
        if (LogTag.JFR_DCMD.shouldLog(LogLevel.DEBUG)) {
            Logger.log(LogTag.JFR_DCMD, LogLevel.DEBUG, "Executing DCmdStart: name=" + string + ", settings=" + (stringArray != null ? Arrays.asList(stringArray) : "(none)") + ", delay=" + l + ", duration=" + l2 + ", disk=" + bl + ", filename=" + string2 + ", maxage=" + l3 + ", maxsize=" + l4 + ", dumponexit =" + bl2 + ", path-to-gc-roots=" + bl3);
        }
        if (string != null) {
            try {
                Integer.parseInt(string);
                throw new DCmdException("Name of recording can't be numeric", new Object[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (l2 == null && Boolean.FALSE.equals(bl2) && string2 != null) {
            throw new DCmdException("Filename can only be set for a time bound recording or if dumponexit=true. Set duration/dumponexit or omit filename.", new Object[0]);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{"default"};
        }
        for (String string3 : stringArray) {
            try {
                hashMap.putAll(JFC.createKnown(string3).getSettings());
            }
            catch (IOException | ParseException exception) {
                throw new DCmdException("Could not parse setting " + stringArray[0], new Object[]{exception});
            }
        }
        OldObjectSample.updateSettingPathToGcRoots(hashMap, bl3);
        if (l2 != null && l2 < 1000000000L) {
            throw new DCmdException("Could not start recording, duration must be at least 1 second.", new Object[0]);
        }
        if (l != null && l < 1000000000L) {
            throw new DCmdException("Could not start recording, delay must be at least 1 second.", new Object[0]);
        }
        if (!FlightRecorder.isInitialized() && l == null) {
            this.initializeWithForcedInstrumentation(hashMap);
        }
        Recording recording = new Recording();
        if (string != null) {
            recording.setName(string);
        }
        if (bl != null) {
            recording.setToDisk(bl);
        }
        recording.setSettings(hashMap);
        SecuritySupport.SafePath safePath = null;
        if (string2 != null) {
            try {
                Path path;
                if (bl2 == null) {
                    bl2 = Boolean.TRUE;
                }
                if (Files.isDirectory(path = Paths.get(string2, new String[0]), new LinkOption[0]) && Boolean.TRUE.equals(bl2)) {
                    PrivateAccess.getInstance().getPlatformRecording(recording).setDumpOnExitDirectory(new SecuritySupport.SafePath(path));
                } else {
                    safePath = this.resolvePath(recording, string2);
                    recording.setDestination(safePath.toPath());
                }
            }
            catch (IOException | InvalidPathException exception) {
                recording.close();
                throw new DCmdException("Could not start recording, not able to write to file %s. %s ", string2, exception.getMessage());
            }
        }
        if (l3 != null) {
            recording.setMaxAge(Duration.ofNanos(l3));
        }
        if (l4 != null) {
            recording.setMaxSize(l4);
        }
        if (l2 != null) {
            recording.setDuration(Duration.ofNanos(l2));
        }
        if (bl2 != null) {
            recording.setDumpOnExit(bl2);
        }
        if (l != null) {
            Duration duration = Duration.ofNanos(l);
            recording.scheduleStart(duration);
            this.print("Recording " + recording.getId() + " scheduled to start in ");
            this.printTimespan(duration, " ");
            this.print(".");
        } else {
            recording.start();
            this.print("Started recording " + recording.getId() + ".");
        }
        if (recording.isToDisk() && l2 == null && l3 == null && l4 == null) {
            this.print(" No limit specified, using maxsize=250MB as default.");
            recording.setMaxSize(0xFA00000L);
        }
        if (safePath != null && l2 != null) {
            this.println(" The result will be written to:", new Object[0]);
            this.println();
            this.printPath(safePath);
        } else {
            String string3;
            this.println();
            this.println();
            String string4 = l2 == null ? "dump" : "stop";
            string3 = string2 == null ? "filename=FILEPATH " : "";
            String string5 = "name=" + recording.getId();
            if (string != null) {
                string5 = "name=" + DCmdStart.quoteIfNeeded(string);
            }
            this.print("Use jcmd " + this.getPid() + " JFR." + string4 + " " + string5 + " " + string3 + "to copy recording data to file.");
            this.println();
        }
        return this.getResult();
    }

    private void initializeWithForcedInstrumentation(Map<String, String> map) {
        if (!this.hasJDKEvents(map)) {
            return;
        }
        JVM jVM = JVM.getJVM();
        try {
            jVM.setForceInstrumentation(true);
            FlightRecorder.getFlightRecorder();
        }
        finally {
            jVM.setForceInstrumentation(false);
        }
    }

    private boolean hasJDKEvents(Map<String, String> map) {
        String[] stringArray = new String[]{"FileRead", "FileWrite", "SocketRead", "SocketWrite", "JavaErrorThrow", "JavaExceptionThrow", "FileForce"};
        for (String string : stringArray) {
            if (!"true".equals(map.get("jdk." + string + "#enabled"))) continue;
            return true;
        }
        return false;
    }
}

