/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.management;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.jfr.EventType;
import jdk.jfr.internal.JVMSupport;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataRepository;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.instrument.JDKEvents;

public final class ManagementSupport {
    public static List<EventType> getEventTypes() {
        Utils.checkAccessFlightRecorder();
        if (JVMSupport.isNotAvailable()) {
            return new ArrayList<EventType>();
        }
        JDKEvents.initialize();
        return Collections.unmodifiableList(MetadataRepository.getInstance().getRegisteredEventTypes());
    }

    public static long parseTimespan(String string) {
        return Utils.parseTimespan(string);
    }

    public static final String formatTimespan(Duration duration, String string) {
        return Utils.formatTimespan(duration, string);
    }

    public static void logError(String string) {
        Logger.log(LogTag.JFR, LogLevel.ERROR, string);
    }
}

