/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.platform;

import java.lang.reflect.Method;
import jdk.Exported;

@Exported
public interface Metrics {
    public static Metrics systemMetrics() {
        try {
            Class<?> clazz = Class.forName("jdk.internal.platform.cgroupv1.Metrics");
            Method method = clazz.getMethod("getInstance", new Class[0]);
            return (Metrics)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }

    public String getProvider();

    public long getCpuUsage();

    public long[] getPerCpuUsage();

    public long getCpuUserUsage();

    public long getCpuSystemUsage();

    public long getCpuPeriod();

    public long getCpuQuota();

    public long getCpuShares();

    public long getCpuNumPeriods();

    public long getCpuNumThrottled();

    public long getCpuThrottledTime();

    public long getEffectiveCpuCount();

    public int[] getCpuSetCpus();

    public int[] getEffectiveCpuSetCpus();

    public int[] getCpuSetMems();

    public int[] getEffectiveCpuSetMems();

    public double getCpuSetMemoryPressure();

    public boolean isCpuSetMemoryPressureEnabled();

    public long getMemoryFailCount();

    public long getMemoryLimit();

    public long getMemoryMaxUsage();

    public long getMemoryUsage();

    public long getKernelMemoryFailCount();

    public long getKernelMemoryLimit();

    public long getKernelMemoryMaxUsage();

    public long getKernelMemoryUsage();

    public long getTcpMemoryFailCount();

    public long getTcpMemoryLimit();

    public long getTcpMemoryMaxUsage();

    public long getTcpMemoryUsage();

    public long getMemoryAndSwapFailCount();

    public long getMemoryAndSwapLimit();

    public long getMemoryAndSwapMaxUsage();

    public long getMemoryAndSwapUsage();

    public boolean isMemoryOOMKillEnabled();

    public long getMemorySoftLimit();

    public long getBlkIOServiceCount();

    public long getBlkIOServiced();
}

