/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.jfr;

import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import jdk.jfr.Recording;
import jdk.management.jfr.Stringifier;

public final class RecordingInfo {
    private final long id;
    private final String name;
    private final String state;
    private final boolean dumpOnExit;
    private final long size;
    private final boolean disk;
    private final long maxAge;
    private final long maxSize;
    private final long startTime;
    private final long stopTime;
    private final String destination;
    private final long durationInSeconds;
    private final Map<String, String> settings;

    RecordingInfo(Recording recording) {
        this.id = recording.getId();
        this.name = recording.getName();
        this.state = recording.getState().toString();
        this.dumpOnExit = recording.getDumpOnExit();
        this.size = recording.getSize();
        this.disk = recording.isToDisk();
        Duration duration = recording.getMaxAge();
        this.maxAge = duration == null ? 0L : duration.getSeconds();
        this.maxSize = recording.getMaxSize();
        Instant instant = recording.getStartTime();
        this.startTime = instant == null ? 0L : instant.toEpochMilli();
        Instant instant2 = recording.getStopTime();
        this.stopTime = instant2 == null ? 0L : instant2.toEpochMilli();
        Path path = recording.getDestination();
        this.destination = path == null ? null : path.toString();
        Duration duration2 = recording.getDuration();
        this.durationInSeconds = duration2 == null ? 0L : duration2.getSeconds();
        this.settings = recording.getSettings();
    }

    private RecordingInfo(CompositeData compositeData) {
        this.id = ((Integer)compositeData.get("id")).intValue();
        this.name = (String)compositeData.get("name");
        this.state = (String)compositeData.get("state");
        this.dumpOnExit = (Boolean)compositeData.get("dumpOnExit");
        this.size = (Long)compositeData.get("size");
        this.disk = (Boolean)compositeData.get("disk");
        this.maxAge = (Long)compositeData.get("maxAge");
        this.maxSize = (Long)compositeData.get("maxSize");
        this.startTime = (Long)compositeData.get("startTime");
        this.stopTime = (Long)compositeData.get("stopTime");
        this.destination = (String)compositeData.get("destination");
        this.durationInSeconds = (Long)compositeData.get("duration");
        this.settings = new LinkedHashMap<String, String>();
        Object object = compositeData.get("settings");
        if (object instanceof TabularData) {
            TabularData tabularData = (TabularData)object;
            List<String> list = tabularData.getTabularType().getIndexNames();
            int n = list.size();
            for (Object obj : tabularData.keySet()) {
                Object[] objectArray = ((List)obj).toArray();
                for (int i = 0; i < n; ++i) {
                    String string = list.get(i);
                    Object object2 = objectArray[i];
                    if (!(object2 instanceof String)) continue;
                    this.settings.put(string, (String)object2);
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.id;
    }

    public boolean getDumpOnExit() {
        return this.dumpOnExit;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public String getState() {
        return this.state;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public String getDestination() {
        return this.destination;
    }

    public String toString() {
        Stringifier stringifier = new Stringifier();
        stringifier.add("name", this.name);
        stringifier.add("id", this.id);
        stringifier.add("maxAge", this.maxAge);
        stringifier.add("maxSize", this.maxSize);
        return stringifier.toString();
    }

    public long getSize() {
        return this.size;
    }

    public boolean isToDisk() {
        return this.disk;
    }

    public long getDuration() {
        return this.durationInSeconds;
    }

    public static RecordingInfo from(CompositeData compositeData) {
        if (compositeData == null) {
            return null;
        }
        return new RecordingInfo(compositeData);
    }
}

